<?xml version="1.0" encoding="UTF-8" standalone="yes"?><xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:saxon="http://saxon.sf.net/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:s="http://www.w3.org/2003/05/soap-envelope" xmlns:wsa="http://www.w3.org/2005/08/addressing" xmlns:i="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:function="http://ato.gov.au/SWSFunctions" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:ref="http://www.xbrl.org/2006/ref" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:xmime="http://www.w3.org/2005/05/xmlmime" xmlns:service="http://sbr.gov.au/comn/list.02.service" xmlns:sbdh="http://sbr.gov.au/comn/sbdm.02.data" xmlns:core="http://sbr.gov.au/comn/core.02.data" xmlns:tech="http://sbr.gov.au/fdtn/sbr.01.02.tech" xmlns:tech.01.03="http://sbr.gov.au/fdtn/sbr.01.03.tech" xmlns:pyde.02.01="http://sbr.gov.au/icls/py/pyde/pyde.02.01.data" xmlns:dtyp.02.15="http://sbr.gov.au/fdtn/sbr.02.15.dtyp" xmlns:pyde.02.05="http://sbr.gov.au/icls/py/pyde/pyde.02.05.data" xmlns:pyde.02.08="http://sbr.gov.au/icls/py/pyde/pyde.02.08.data" xmlns:tech.01.02="http://sbr.gov.au/fdtn/sbr.01.02.tech" xmlns:pyde.02.00="http://sbr.gov.au/icls/py/pyde/pyde.02.00.data" xmlns:pyid.02.03="http://sbr.gov.au/icls/py/pyid/pyid.02.03.data" xmlns:dtyp.02.03="http://sbr.gov.au/fdtn/sbr.02.03.dtyp" xmlns:dtyp.02.13="http://sbr.gov.au/fdtn/sbr.02.13.dtyp" xmlns:dtyp.02.09="http://sbr.gov.au/fdtn/sbr.02.09.dtyp" xmlns:pyid.02.00="http://sbr.gov.au/icls/py/pyid/pyid.02.00.data" xmlns:pyid.02.05="http://sbr.gov.au/icls/py/pyid/pyid.02.05.data" xmlns:emsup.02.03="http://sbr.gov.au/icls/em/emsup/emsup.02.03.data" xmlns:emsup.02.08="http://sbr.gov.au/icls/em/emsup/emsup.02.08.data" xmlns:emsup.02.18="http://sbr.gov.au/icls/em/emsup/emsup.02.18.data" xmlns:dtyp.02.00="http://sbr.gov.au/fdtn/sbr.02.00.dtyp" xmlns:pyin.02.14="http://sbr.gov.au/icls/py/pyin/pyin.02.14.data" xmlns:pyde.02.10="http://sbr.gov.au/icls/py/pyde/pyde.02.10.data" xmlns:pyde.02.12="http://sbr.gov.au/icls/py/pyde/pyde.02.12.data" xmlns:pyde.02.18="http://sbr.gov.au/icls/py/pyde/pyde.02.18.data" xmlns:RprtPyType.02.16="http://sbr.gov.au/dims/RprtPyType.02.16.dims" xmlns:orgname1.02.00="http://sbr.gov.au/comnmdle/comnmdle.organisationname1.02.00.module" xmlns:prsnstrcnm1.02.00="http://sbr.gov.au/comnmdle/comnmdle.personstructuredname1.02.00.module" xmlns:prsnstrcnm3.02.01="http://sbr.gov.au/comnmdle/comnmdle.personstructuredname3.02.01.module" xmlns:email1.02.00="http://sbr.gov.au/comnmdle/comnmdle.electroniccontactelectronicmail1.02.00.module" xmlns:phone1.02.00="http://sbr.gov.au/comnmdle/comnmdle.electroniccontacttelephone1.02.00.module" xmlns:address3.02.01="http://sbr.gov.au/comnmdle/comnmdle.addressdetails3.02.01.module" xmlns:sprcnt.0003.memreg.req.02.00="http://sbr.gov.au/rprt/sprstrm/sprcnt/sprcnt.0003.memreg.request.02.00.report" xmlns:ReportingPartyABN.02.00_typedelement="http://sbr.gov.au/dims/ReportingPartyABN.02.00.dims" xmlns:EmpAbn.02.00_typedelement="http://sbr.gov.au/dims/EmpAbn.02.00.dims" xmlns:SprFndAbn.02.00_typedelement="http://sbr.gov.au/dims/SprFndAbn.02.00.dims" xmlns:SprFndUSI.02.00_typedelement="http://sbr.gov.au/dims/SprFndUSI.02.00.dims" version="2.0"><!--
            Implementers: please note that overriding process-prolog or process-root is
            the preferred method for meta-stylesheets to use where possible.
        -->


<!--PHASES-->


<!--PROLOG-->
<xsl:import xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" href="SSCMR202607Validator_Functions.xsl"/><xsl:variable xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" name="document-uri"><xsl:value-of select="document-uri(/)"/></xsl:variable><xsl:variable name="Apostrophe">'</xsl:variable><xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" method="xml" omit-xml-declaration="no" standalone="yes" indent="no"/><xsl:param xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" name="document-id"/><!--MODE: SCHEMATRON-FULL-PATH-2ATO-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" match="node() | @*" mode="schematron-get-full-path-2ato"><xsl:for-each select="ancestor-or-self::*"><xsl:if test="name(.) != 'documents' and name(.) != 'document'"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="preceding-sibling::*[name(.)=name(current())]"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template>

<!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->
<xsl:key name="contextById" match="/xbrli:xbrl/xbrli:context" use="@id"/><xsl:key name="contextDetailsById" match="/xbrli:xbrl/*" use="@contextRef | */@contextRef"/><xsl:key name="contextByIdentifier" match="/xbrli:xbrl/xbrli:context" use="xbrli:entity/xbrli:identifier"/>

<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path"><xsl:apply-templates select="." mode="schematron-get-full-path"/></xsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path"><xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/><xsl:text>/</xsl:text><xsl:choose><xsl:when test="namespace-uri()=''"><xsl:value-of select="name()"/></xsl:when><xsl:otherwise><xsl:text>*:</xsl:text><xsl:value-of select="local-name()"/><xsl:text>[namespace-uri()='</xsl:text><xsl:value-of select="namespace-uri()"/><xsl:text>']</xsl:text></xsl:otherwise></xsl:choose><xsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/><xsl:text>[</xsl:text><xsl:value-of select="1+ $preceding"/><xsl:text>]</xsl:text></xsl:template><xsl:template match="@*" mode="schematron-get-full-path"><xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/><xsl:text>/</xsl:text><xsl:choose><xsl:when test="namespace-uri()=''">
                            @<xsl:value-of select="name()"/></xsl:when><xsl:otherwise><xsl:text>@*[local-name()='</xsl:text><xsl:value-of select="local-name()"/><xsl:text>' and namespace-uri()='</xsl:text><xsl:value-of select="namespace-uri()"/><xsl:text>']</xsl:text></xsl:otherwise></xsl:choose></xsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="preceding-sibling::*[name(.)=name(current())]"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template><!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--
            This mode can be used to generate prefixed XPath for humans
            (Top-level element has index)
        -->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="parent::*"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template>

<!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/><xsl:template match="text()" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/></xsl:template><xsl:template match="comment()" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/></xsl:template><xsl:template match="processing-instruction()" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/></xsl:template><xsl:template match="@*" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.@', name())"/></xsl:template><xsl:template match="*" mode="generate-id-from-path" priority="-0.5"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:text>.</xsl:text><xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/></xsl:template>

<!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template><xsl:template match="*" mode="generate-id-2" priority="2"><xsl:text>U</xsl:text><xsl:number level="multiple" count="*"/></xsl:template><xsl:template match="node()" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number level="multiple" count="*"/><xsl:text>n</xsl:text><xsl:number count="node()"/></xsl:template><xsl:template match="@*" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number level="multiple" count="*"/><xsl:text>_</xsl:text><xsl:value-of select="string-length(local-name(.))"/><xsl:text>_</xsl:text><xsl:value-of select="translate(name(),':','.')"/></xsl:template><!--Strip characters--><xsl:template match="text()" priority="-1"/>

<!--SCHEMA SETUP-->
<xsl:template match="/"><xsl:variable xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" name="results"><xsl:apply-templates select="/" mode="M57"/><xsl:apply-templates select="/" mode="M58"/><xsl:apply-templates select="/" mode="M59"/><xsl:apply-templates select="/" mode="M60"/></xsl:variable><xsl:if xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" test="$results"><xsl:element name="tns:Event" namespace="http://sbr.gov.au/comn/event.02.data" inherit-namespaces="no"><xsl:element name="tns:MaximumSeverity.Code"><xsl:choose><xsl:when test="$results//tns:Severity.Code[.='Error']">Error</xsl:when><xsl:when test="$results//tns:Severity.Code[.='Partial']">Partial</xsl:when><xsl:when test="$results//tns:Severity.Code[.='Warning']">Warning</xsl:when><xsl:when test="$results//tns:Severity.Code[.='Information']">Information</xsl:when><xsl:when test="$results//tns:Severity.Code[.='Progressive']">Progressive</xsl:when><xsl:otherwise>Information</xsl:otherwise></xsl:choose></xsl:element><xsl:element name="tns:EventItems"><xsl:if test="not($results//tns:Severity.Code[.='Error'] or  $results//tns:Severity.Code[.='Partial'])"><xsl:element name="tns:EventItem"><xsl:element name="tns:Error.Code">CMN.ATO.GEN.OK</xsl:element><xsl:element name="tns:Severity.Code">Information</xsl:element><xsl:element name="tns:Short.Description">Message accepted</xsl:element><xsl:element name="tns:Locations"><xsl:element name="tns:Location"><xsl:element name="tns:Location.Instance.Identifier"><xsl:value-of select="$document-id"/></xsl:element></xsl:element></xsl:element></xsl:element></xsl:if><xsl:copy-of copy-namespaces="no" select="$results"/></xsl:element></xsl:element></xsl:if></xsl:template>

<!--SCHEMATRON PATTERNS-->


<!--
                PATTERN VariablesXBRL variables that are applicable accross all of the SSCMR services.-->
<xsl:variable name="RP.Employer.Context" select="/xbrli:xbrl/xbrli:context[             not(@i:nil='true')              and              xbrli:entity/xbrli:segment             [                 count(xbrldi:explicitMember) = 1                  and                 count(xbrldi:typedMember) = 0                  and                 xbrldi:explicitMember                 [                    matches(@dimension,'^RprtPyType\.\d{2}\.\d{2}:ReportPartyTypeDimension$')                   and                    matches(.,'^RprtPyType\.\d{2}\.\d{2}:Employer$')                     ]              ]         ]"/><xsl:variable name="RP.Employer.ContextId" select="$RP.Employer.Context/@id"/><xsl:variable name="RP.MessageReceiver.Context" select="/xbrli:xbrl/xbrli:context[             not(@i:nil='true')              and              xbrli:entity/xbrli:segment             [                 count(xbrldi:explicitMember) = 1                  and                 count(xbrldi:typedMember) = 0                  and                 xbrldi:explicitMember                 [                      matches(@dimension,'^RprtPyType\.\d{2}\.\d{2}:ReportPartyTypeDimension$')                     and                      matches(.,'^RprtPyType\.\d{2}\.\d{2}:MessageReceiver$')                     ]              ]         ]"/><xsl:variable name="RP.MessageReceiver.ContextId" select="$RP.MessageReceiver.Context/@id"/><xsl:variable name="RP.MessageSender.Context" select="/xbrli:xbrl/xbrli:context[             not(@i:nil='true')              and              xbrli:entity/xbrli:segment             [                 count(xbrldi:explicitMember) = 1                  and                 count(xbrldi:typedMember) = 0                  and                 xbrldi:explicitMember                 [                      matches(@dimension,'^RprtPyType\.\d{2}\.\d{2}:ReportPartyTypeDimension$')                     and                      matches(.,'^RprtPyType\.\d{2}\.\d{2}:MessageSender$')                     ]              ]         ]"/><xsl:variable name="RP.MessageSender.ContextId" select="$RP.MessageSender.Context/@id"/><xsl:variable name="RP.SuperFundMember.Context" select="/xbrli:xbrl/xbrli:context[             not(@i:nil='true')              and              xbrli:entity/xbrli:segment             [                 count(xbrldi:explicitMember) = 1                  and                 (count(xbrldi:typedMember) &gt;= 2 and count(xbrldi:typedMember) &lt;= 3)                 and                   xbrldi:explicitMember                 [                      matches(@dimension,'^RprtPyType\.\d{2}\.\d{2}:ReportPartyTypeDimension$')                     and                      matches(.,'^RprtPyType\.\d{2}\.\d{2}:SuperFundMember$')                     ]              ]         ]"/><xsl:variable name="RP.SuperFundMember.ContextId" select="$RP.SuperFundMember.Context/@id"/><xsl:template match="text()" priority="-1" mode="M57"/><xsl:template match="@*|node()" priority="-2" mode="M57"><xsl:apply-templates select="*" mode="M57"/></xsl:template>

<!--
                PATTERN ContextValidations for contexts that are applicable accross all of the SSCMR services.-->


	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/xbrli:context[not(@i:nil='true')]" priority="1002" mode="M58"><xsl:variable name="thisContextId" select="@id"/><xsl:variable name="thisIdentifier" select="xbrli:entity/xbrli:identifier"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 xbrli:entity/xbrli:segment/xbrldi:explicitMember                 [                               not(@i:nil='true')                      and (ends-with(@dimension, ':ReportPartyTypeDimension')                      or @dimension = 'ReportPartyTypeDimension')                     and (ends-with(., ':MessageSender')                      or . = 'MessageSender')                 ]                 and                 xbrli:entity/xbrli:identifier                 [                     not(matches(@scheme, '^http://www.abr.gov.au/abn$'))                 ]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.14</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Invalid Entity Identifier Scheme {entityIdScheme}</tns:Short.Description><tns:Detailed.Description>Invalid value supplied for Entity Identifier Scheme - must be {url}. Please correct and resubmit.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>entityIdScheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100002</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:entity/xbrli:identifier</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 xbrli:entity/xbrli:segment/xbrldi:explicitMember                 [                               not(@i:nil='true')                      and (ends-with(@dimension, ':ReportPartyTypeDimension')                      or @dimension = 'ReportPartyTypeDimension')                     and (ends-with(., ':MessageReceiver')                      or . = 'MessageReceiver')                 ]                 and                 xbrli:entity/xbrli:identifier                 [                     not(matches(@scheme, '^http://www.abr.gov.au/abn$'))                 ]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.14</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Invalid Entity Identifier Scheme {entityIdScheme}</tns:Short.Description><tns:Detailed.Description>Invalid value supplied for Entity Identifier Scheme - must be {url}. Please correct and resubmit.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>entityIdScheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100003</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:entity/xbrli:identifier</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 xbrli:entity/xbrli:segment/xbrldi:explicitMember                 [                               not(@i:nil='true')                      and (ends-with(@dimension, ':ReportPartyTypeDimension')                      or @dimension = 'ReportPartyTypeDimension')                     and (ends-with(., ':Payer')                      or . = 'Payer')                 ]                 and                 xbrli:entity/xbrli:identifier                 [                     not(matches(@scheme, '^http://www.abr.gov.au/abn$'))                 ]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.14</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Invalid Entity Identifier Scheme {entityIdScheme}</tns:Short.Description><tns:Detailed.Description>Invalid value supplied for Entity Identifier Scheme - must be {url}. Please correct and resubmit.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>entityIdScheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.200001</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:entity/xbrli:identifier</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 xbrli:entity/xbrli:segment/xbrldi:explicitMember                 [                               not(@i:nil='true')                      and (ends-with(@dimension, ':ReportPartyTypeDimension')                      or @dimension = 'ReportPartyTypeDimension')                     and (ends-with(., ':Payee')                      or . = 'Payee')                 ]                 and                 xbrli:entity/xbrli:identifier                 [                     not(matches(@scheme, '^http://www.abr.gov.au/abn$'))                 ]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.14</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Invalid Entity Identifier Scheme {entityIdScheme}</tns:Short.Description><tns:Detailed.Description>Invalid value supplied for Entity Identifier Scheme - must be {url}. Please correct and resubmit.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>entityIdScheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.200002</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:entity/xbrli:identifier</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 xbrli:entity/xbrli:identifier                 [                                     matches(@scheme, '^http://www.ato.gov.au/tfn$')                     and                     not(function:ValidateTFN(.))                 ]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.9</tns:Error.Code><tns:Severity.Code>Warning</tns:Severity.Code><tns:Short.Description>TFN failed the TFN algorithm check.</tns:Short.Description><tns:Detailed.Description>TFN {tfn} failed the TFN algorithm check.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tfn</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000042</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:entity/xbrli:identifier</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 exists($RP.SuperFundMember.Context[generate-id() = generate-id(current())])                 and                 xbrli:entity/xbrli:identifier                 [                     not(matches(@scheme, '^http://www.ato.gov.au/tfn$')                     or                     matches(@scheme, '^http://www.sbr.gov.au/id$'))                 ]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.14</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Invalid Entity Identifier Scheme {entityIdScheme}</tns:Short.Description><tns:Detailed.Description>Invalid value supplied for Entity Identifier Scheme - must be {url}. Please correct and resubmit.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>entityIdScheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.ato.gov.au/tfn or http://www.sbr.gov.au/id</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.200006</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:entity/xbrli:identifier</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 xbrli:entity/xbrli:segment/xbrldi:explicitMember                 [                               not(@i:nil='true')                      and (ends-with(@dimension, ':ReportPartyTypeDimension')                      or @dimension = 'ReportPartyTypeDimension')                     and (ends-with(., ':Employer')                      or . = 'Employer')                 ]                 and                 xbrli:entity/xbrli:identifier                 [                     not(matches(@scheme, '^http://www.abr.gov.au/abn$'))                 ]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.14</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Invalid Entity Identifier Scheme {entityIdScheme}</tns:Short.Description><tns:Detailed.Description>Invalid value supplied for Entity Identifier Scheme - must be {url}. Please correct and resubmit.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>entityIdScheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000006</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:entity/xbrli:identifier</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 xbrli:entity/xbrli:segment/xbrldi:explicitMember                 [                               not(@i:nil='true')                      and (ends-with(@dimension, ':ReportPartyTypeDimension')                      or @dimension = 'ReportPartyTypeDimension')                     and (ends-with(., ':MessageReceiver')                      or . = 'MessageReceiver')                 ]                 and                 xbrli:entity/xbrli:identifier                 [                     not(function:ValidateABN(.))                 ]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>ABN {abn} is not valid.</tns:Short.Description><tns:Detailed.Description>Please check the ABN to confirm that the number is correct. See {url} for more information.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>abn</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000040</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:entity/xbrli:identifier</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M58"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl" priority="1001" mode="M58">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(exists($RP.MessageSender.ContextId))             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.6</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Missing context declaration.</tns:Short.Description><tns:Detailed.Description>Instance document MUST contain {contextcount} {contextname} context declarations.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.SENDER</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>MessageSender</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000001</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count($RP.MessageSender.ContextId) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.10</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Too many instances of a context declaration.</tns:Short.Description><tns:Detailed.Description>Context {contextname} may only contain {contextcount} occurrences within the instance document.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.SENDER</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>MessageSender</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000002</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(exists($RP.MessageReceiver.ContextId))             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.6</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Missing context declaration.</tns:Short.Description><tns:Detailed.Description>Instance document MUST contain {contextcount} {contextname} context declarations.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.RECEIVER</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>MessageReceiver</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000003</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count($RP.MessageReceiver.ContextId) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.10</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Too many instances of a context declaration.</tns:Short.Description><tns:Detailed.Description>Context {contextname} may only contain {contextcount} occurrences within the instance document.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.RECEIVER</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>MessageReceiver</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000004</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not($RP.Employer.ContextId)             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.6</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Missing context declaration.</tns:Short.Description><tns:Detailed.Description>Instance document MUST contain {contextcount} {contextname} context declarations.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1 or more</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.EMPLOYER</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>Employer</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000005</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not($RP.SuperFundMember.ContextId)             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.6</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Missing context declaration.</tns:Short.Description><tns:Detailed.Description>Instance document MUST contain {contextcount} {contextname} context declarations.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1 or more</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.SUPERFUNDMEMBER</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>SuperFundMember</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000041</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M58"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrldi:typedMember[not(@i:nil='true') and ends-with(@dimension,':SuperFundABNDimension')]/*" priority="1000" mode="M58">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 (                     ends-with(name(), ':Identifiers.AustralianBusinessNumber.Identifier')                      or                      name() = 'Identifiers.AustralianBusinessNumber.Identifier'                 )                 and                 not(function:ValidateABN(.))             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>ABN {abn} is not valid.</tns:Short.Description><tns:Detailed.Description>Please check the ABN to confirm that the number is correct. See {url} for more information.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>abn</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="../../../xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(../../xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="../../../../@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="../../../xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="../../../xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.200008</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M58"/></xsl:template><xsl:template match="text()" priority="-1" mode="M58"/><xsl:template match="@*|node()" priority="-2" mode="M58"><xsl:apply-templates select="*" mode="M58"/></xsl:template>

<!--
                PATTERN MandatoriesMandatory Validations-->


	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/orgname1.02.00:OrganisationNameDetails" priority="1007" mode="M59"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000006</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:OrganisationNameDetails.OrganisationalName.Text[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:OrganisationNameDetails.OrganisationalName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000008</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:OrganisationNameDetails.OrganisationalName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M59"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/prsnstrcnm1.02.00:PersonNameDetails" priority="1006" mode="M59"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.FamilyName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000010</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonNameDetails.FamilyName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.GivenName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000011</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonNameDetails.GivenName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M59"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/prsnstrcnm3.02.01:PersonNameDetails" priority="1005" mode="M59"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.FamilyName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000036</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonNameDetails.FamilyName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.GivenName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000037</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonNameDetails.GivenName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M59"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/email1.02.00:ElectronicContactElectronicMail" priority="1004" mode="M59"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000013</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.ElectronicMail.Address.Text[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.ElectronicMail.Address.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000015</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.ElectronicMail.Address.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M59"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/phone1.02.00:ElectronicContactTelephone" priority="1003" mode="M59"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.Telephone.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000017</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.Telephone.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000019</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.Telephone.Minimal.Number[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.Telephone.Minimal.Number</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000020</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.Telephone.Minimal.Number</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M59"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/address3.02.01:AddressDetails" priority="1002" mode="M59"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.01:AddressDetails.Usage.Code[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.01:AddressDetails.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000026</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.01:AddressDetails.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:AddressDetails.Line1.Text[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.Line1.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000028</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.Line1.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:AddressDetails.LocalityName.Text[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.LocalityName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000029</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.LocalityName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.08:AddressDetails.Country.Code[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.08:AddressDetails.Country.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000032</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.08:AddressDetails.Country.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M59"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl" priority="1001" mode="M59">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $RP.MessageSender.ContextId)[self::orgname1.02.00:OrganisationNameDetails])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageSender.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000007</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $RP.MessageSender.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>prsnstrcnm1.02.00:PersonNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageSender.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000009</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm1.02.00:PersonNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $RP.MessageSender.ContextId)[self::email1.02.00:ElectronicContactElectronicMail])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>email1.02.00:ElectronicContactElectronicMail</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageSender.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000011</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/email1.02.00:ElectronicContactElectronicMail</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $RP.MessageSender.ContextId)[self::phone1.02.00:ElectronicContactTelephone])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>phone1.02.00:ElectronicContactTelephone</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageSender.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000013</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/phone1.02.00:ElectronicContactTelephone</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $RP.MessageReceiver.ContextId)[self::orgname1.02.00:OrganisationNameDetails])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageReceiver.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageReceiver.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageReceiver.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageReceiver.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000015</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $RP.Employer.ContextId)[self::orgname1.02.00:OrganisationNameDetails])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.Employer.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.Employer.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.Employer.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.Employer.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000017</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M59"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/xbrli:context[generate-id() = $RP.SuperFundMember.Context/generate-id()]" priority="1000" mode="M59"><xsl:variable name="thisContextId" select="@id"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails[not(@i:nil = 'true')]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>prsnstrcnm3.02.01:PersonNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000019</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm3.02.01:PersonNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::pyde.02.18:PersonDemographicDetails.Sex.Code[not(@i:nil = 'true' or string-length(.) = 0)]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.18:PersonDemographicDetails.Sex.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000024</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.18:PersonDemographicDetails.Sex.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::pyde.02.00:PersonDemographicDetails.Birth.Date[not(@i:nil = 'true' or string-length(.) = 0)]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonDemographicDetails.Birth.Date</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000025</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonDemographicDetails.Birth.Date</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails[not(@i:nil = 'true')]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>address3.02.01:AddressDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000026</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/address3.02.01:AddressDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[not(@i:nil = 'true' or string-length(.) = 0)]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000030</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::sprcnt.0003.memreg.req.02.00:MemberRegistrationOtherDetails]/emsup.02.08:SuperannuationFundDetails.MemberRegistrationOtherDetails.Text[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>emsup.02.08:SuperannuationFundDetails.MemberRegistrationOtherDetails.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000031</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/sprcnt.0003.memreg.req.02.00:MemberRegistrationOtherDetails/emsup.02.08:SuperannuationFundDetails.MemberRegistrationOtherDetails.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::sprcnt.0003.memreg.req.02.00:MemberRegistrationOtherDetails]/emsup.02.08:SuperannuationFundDetails.MemberRegistrationOtherDetails.Description[not(@i:nil = 'true' or string-length(.) = 0)])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>emsup.02.08:SuperannuationFundDetails.MemberRegistrationOtherDetails.Description</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000032</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/sprcnt.0003.memreg.req.02.00:MemberRegistrationOtherDetails/emsup.02.08:SuperannuationFundDetails.MemberRegistrationOtherDetails.Description</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M59"/></xsl:template><xsl:template match="text()" priority="-1" mode="M59"/><xsl:template match="@*|node()" priority="-2" mode="M59"><xsl:apply-templates select="*" mode="M59"/></xsl:template>

<!--
                PATTERN ContentContent Validations-->


	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/orgname1.02.00:OrganisationNameDetails" priority="1005" mode="M60"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil = 'true') and not(. = 'MN')]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an invalid value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>MN</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000007</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M60"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/email1.02.00:ElectronicContactElectronicMail" priority="1004" mode="M60"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(@i:nil = 'true') and not(. = '03')]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an invalid value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>03</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000014</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M60"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/phone1.02.00:ElectronicContactTelephone" priority="1003" mode="M60"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(@i:nil = 'true') and not(. = '03')]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an invalid value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.Telephone.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>03</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000018</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.Telephone.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil = 'true') and not(matches(., '^(01|02)$'))]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an invalid value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>01 or 02</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000021</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M60"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/address3.02.01:AddressDetails" priority="1002" mode="M60"><xsl:variable name="thisContextId" select="./*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.01:AddressDetails.Usage.Code[not(@i:nil = 'true') and not(matches(., '^(POS|RES)$'))]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an invalid value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.01:AddressDetails.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>POS or RES</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000027</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.01:AddressDetails.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.08:AddressDetails.Country.Code[. = 'au']                 and                 not(pyde.02.00:AddressDetails.Postcode.Text[not(@i:nil = 'true')])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.7</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Conditional data element rule failure.</tns:Short.Description><tns:Detailed.Description>{elementname1} MUST be provided if {elementname2} is set to {elementname2value}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname1</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.Postcode.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.08:AddressDetails.Country.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2value</tns:Parameter.Identifier><tns:Parameter.Text>au</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000030</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.Postcode.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.08:AddressDetails.Country.Code[. = 'au']                 and                 not(pyde.02.00:AddressDetails.StateOrTerritory.Code[not(@i:nil = 'true')])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.7</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Conditional data element rule failure.</tns:Short.Description><tns:Detailed.Description>{elementname1} MUST be provided if {elementname2} is set to {elementname2value}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname1</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.StateOrTerritory.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.08:AddressDetails.Country.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2value</tns:Parameter.Identifier><tns:Parameter.Text>au</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000031</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.StateOrTerritory.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.00:AddressDetails.LocalityName.Text[string-length(.) &gt; 50]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an invalid value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.LocalityName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>a string with no more than 50 characters</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById', $thisContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000038</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.LocalityName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M60"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl" priority="1001" mode="M60">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>$RP.MessageSender.ContextId</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageSender.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000008</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>prsnstrcnm1.02.00:PersonNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>$RP.MessageSender.Context</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageSender.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000010</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm1.02.00:PersonNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>email1.02.00:ElectronicContactElectronicMail</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>$RP.MessageSender.ContextId</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageSender.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000012</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/email1.02.00:ElectronicContactElectronicMail</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::phone1.02.00:ElectronicContactTelephone]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>phone1.02.00:ElectronicContactTelephone</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>$RP.MessageSender.ContextId</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageSender.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageSender.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000014</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/phone1.02.00:ElectronicContactTelephone</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $RP.MessageReceiver.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>$RP.MessageReceiver.ContextId</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.MessageReceiver.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageReceiver.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageReceiver.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.MessageReceiver.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000016</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $RP.Employer.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>$RP.Employer.ContextId</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after($RP.Employer.Context/xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.Employer.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.Employer.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RP.Employer.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000018</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M60"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl/xbrli:context[generate-id() = $RP.SuperFundMember.Context/generate-id()]" priority="1000" mode="M60"><xsl:variable name="thisContextId" select="@id"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>prsnstrcnm3.02.01:PersonNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.SUPERFUNDMEMBER</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000020</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm3.02.01:PersonNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]/pyde.02.00:PersonNameDetails.PersonNameType.Code[not(@i:nil = 'true') and not(. = 'LGL')]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an invalid value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.PersonNameType.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>LGL</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000021</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm3.02.01:PersonNameDetails/pyde.02.00:PersonNameDetails.PersonNameType.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]/pyde.02.05:PersonNameDetails.Usage.Code[not(@i:nil = 'true') and not(. = 'Contact')]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an invalid value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.05:PersonNameDetails.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>Contact</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000022</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm3.02.01:PersonNameDetails/pyde.02.05:PersonNameDetails.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]/pyde.02.00:PersonNameDetails.Currency.Code[not(@i:nil = 'true') and not(. = 'C')]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an invalid value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.Currency.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>C</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000023</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm3.02.01:PersonNameDetails/pyde.02.00:PersonNameDetails.Currency.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>address3.02.01:AddressDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.SUPERFUNDMEMBER</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000027</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/address3.02.01:AddressDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $thisContextId)[self::email1.02.00:ElectronicContactElectronicMail]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>email1.02.00:ElectronicContactElectronicMail</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>maximum 1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.SUPERFUNDMEMBER</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000028</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/email1.02.00:ElectronicContactElectronicMail</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $thisContextId)[self::phone1.02.00:ElectronicContactTelephone]) &gt; 2             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>phone1.02.00:ElectronicContactTelephone</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>maximum 2</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>RP.SuperFundMember</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000029</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/phone1.02.00:ElectronicContactTelephone</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[. = 'false']]                 and                 xbrli:entity/xbrli:identifier[matches(@scheme, '^http://www.sbr.gov.au/id$')]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>TFN quoted indicator does not match Entity ID scheme.</tns:Short.Description><tns:Detailed.Description>Identifiers.TaxFileNumberNotProvided.Indicator has been set to {value} however the Entity ID Scheme is set to {entityscheme}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>value</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="../pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>entityscheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000033</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[. = 'true']]                 and                 xbrli:entity/xbrli:identifier[matches(@scheme, '^http://www.ato.gov.au/tfn$')]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>TFN quoted indicator does not match Entity ID scheme.</tns:Short.Description><tns:Detailed.Description>Identifiers.TaxFileNumberNotProvided.Indicator has been set to {value} however the Entity ID Scheme is set to {entityscheme}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>value</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="../pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>entityscheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember, ':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>EmployersABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'EmployersABNDimension']/EmpAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundABNDimension']/SprFndAbn.02.00_typedelement:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>SuperFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[substring-after(@dimension, ':') = 'SuperFundUniqueSuperannuationIdentifierDimension']/SprFndUSI.02.00_typedelement:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.CMR.000034</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M60"/></xsl:template><xsl:template match="text()" priority="-1" mode="M60"/><xsl:template match="@*|node()" priority="-2" mode="M60"><xsl:apply-templates select="*" mode="M60"/></xsl:template></xsl:stylesheet>